# -*- coding: utf-8 -*-
# Generated by Django 1.11.11 on 2018-04-03 12:45


from django.db import (
    migrations,
    models,
)


def migrate(apps, schema_editor):
    remove_empty_changes(apps)
    lower_approve_level_to_its_max(apps)


def remove_empty_changes(apps):
    PersonReviewChange = apps.get_model('core', 'PersonReviewChange')
    changes = PersonReviewChange.objects.all()
    bad_ids = (
        it.id for it in changes
        if (
            'reviewers' in it.diff and
            it.diff['reviewers']['new'] == it.diff['reviewers']['old']
        )
    )
    PersonReviewChange.objects.filter(id__in=bad_ids).delete()


def lower_approve_level_to_its_max(apps):
    to_upd = apps.get_model('core', 'PersonReview').objects.annotate(
        max_pos=models.Max('role__position'),
    ).filter(
        max_pos__lt=models.F('approve_level'),
    )
    for pr in to_upd:
        pr.approve_level = pr.max_pos
        pr.save()


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0049_level_change_cant_be_auto'),
    ]

    operations = [
        migrations.RunPython(migrate),
    ]
