# -*- coding: utf-8 -*-


from django.db import migrations


def create_default_mark_scale(apps, schema_editor):
    scale = {
        'A': 1,
        'B': 1,
        'C-': 2,
        'C': 3,
        'D': 4,
        'E': 5,
    }
    scale = apps.get_model('core', 'MarksScale').objects.create(
        scale=scale
    )
    apps.get_model('core', 'Review').objects.update(scale_id=scale.id)


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0052_auto_20180629_1313'),
    ]

    operations = [
        migrations.RunPython(create_default_mark_scale),
    ]
