# -*- coding: utf-8 -*-
# Generated by Django 1.11.11 on 2018-04-03 12:45


from itertools import chain

from django.db import migrations


def remove_same_reviewers_change(apps, schema_editor):
    for change in apps.get_model('core', 'PersonReviewChange').objects.all():
        diff = change.diff
        reviewers = diff.get('reviewers')
        if not reviewers:
            continue
        if all(isinstance(el, str) for el in chain(*list(reviewers.values()))):
            continue
        for li in list(reviewers.values()):
            li[:] = [
                sorted(el) if isinstance(el, list) else el
                for el in li
            ]
        if reviewers['old'] == reviewers['new']:
            del diff['reviewers']
        if not diff:
            change.delete()
        else:
            change.save()


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0053_create_default_mark_scale'),
    ]

    operations = [
        migrations.RunPython(remove_same_reviewers_change),
    ]
