# -*- coding: utf-8 -*-
# Generated by Django 1.11.28 on 2021-01-22 08:22


from django.db import migrations, models
from django.db import connection
from django.conf import settings


def migrate(apps, schema_editor):
    if settings.DATABASES['default']['ENGINE'] not in (
        'django_pgaas.backend',
        'django.db.backends.postgresql',
    ):
        return
    with connection.cursor() as cursor:
        cursor.execute(
            """
                UPDATE core_review
                SET feedback_from_date = coalesce(evaluation_from_date, start_date - interval '6 month'),
                    feedback_to_date = coalesce(evaluation_to_date, start_date)
            """
        )


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0069_fix_default_marks_version'),
    ]

    operations = [
        migrations.AddField(
            model_name='review',
            name='bonus_reason',
            field=models.TextField(null=True),
        ),
        migrations.AddField(
            model_name='review',
            name='bonus_type',
            field=models.CharField(choices=[('y', 'yearly'), ('q', 'quarterly'), ('h', 'halfyearly'), ('s', 'single'), ('m', 'monthly'), ('p', 'project')], default='h', max_length=1),
        ),
        migrations.AddField(
            model_name='review',
            name='feedback_from_date',
            field=models.DateField(blank=True, default=None, null=True),
        ),
        migrations.AddField(
            model_name='review',
            name='feedback_to_date',
            field=models.DateField(blank=True, default=None, null=True),
        ),
        migrations.AlterField(
            model_name='review',
            name='type',
            field=models.CharField(choices=[('p', 'promotion'), ('b', 'bonus'), ('m', 'middle'), ('n', 'normal')], default='n', max_length=1),
        ),
        migrations.RunPython(code=migrate),
    ]
