# -*- coding: utf-8 -*-
# Generated by Django 1.11.28 on 2021-07-20 19:37


from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0071_add_excel_templates'),
    ]

    operations = [
        migrations.CreateModel(
            name='MainProduct',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('issue_key', models.CharField(max_length=255, unique=True)),
                ('name', models.CharField(max_length=255)),
                ('abc_service_id', models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='MainProductReview',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('main_product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='main_product_reviews', related_query_name='main_product_review', to='core.MainProduct')),
            ],
        ),
        migrations.CreateModel(
            name='Umbrella',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('issue_key', models.CharField(max_length=255, unique=True)),
                ('name', models.CharField(max_length=255)),
                ('main_product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='umbrellas', related_query_name='umbrella', to='core.MainProduct')),
            ],
        ),
        migrations.CreateModel(
            name='UmbrellaPersonReview',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('person_review', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='umbrella_person_reviews', related_query_name='umbrella_person_review', to='core.PersonReview')),
                ('umbrella', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='umbrella_person_reviews', related_query_name='umbrella_person_review', to='core.Umbrella')),
            ],
        ),
        migrations.CreateModel(
            name='UmbrellaReview',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.AlterField(
            model_name='review',
            name='bonus_type',
            field=models.CharField(choices=[('q', 'quarterly'), ('h', 'halfyearly'), ('s', 'single'), ('m', 'monthly'), ('p', 'project')], default='h', max_length=1),
        ),
        migrations.AddField(
            model_name='umbrellareview',
            name='review',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='umbrella_reviews', related_query_name='umbrella_review', to='core.Review'),
        ),
        migrations.AddField(
            model_name='umbrellareview',
            name='umbrella',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='umbrella_reviews', related_query_name='umbrella_review', to='core.Umbrella'),
        ),
        migrations.AddField(
            model_name='mainproductreview',
            name='review',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='main_product_reviews', related_query_name='main_product_review', to='core.Review'),
        ),
        migrations.AlterUniqueTogether(
            name='umbrellareview',
            unique_together=set([('review', 'umbrella')]),
        ),
        migrations.AlterUniqueTogether(
            name='umbrellapersonreview',
            unique_together=set([('person_review', 'umbrella')]),
        ),
        migrations.AlterUniqueTogether(
            name='mainproductreview',
            unique_together=set([('review', 'main_product')]),
        ),
    ]
