# -*- coding: utf-8 -*-
# Generated by Django 1.11.28 on 2021-09-18 00:03
from __future__ import unicode_literals

from django.db import migrations, models
from django.conf import settings


def migrate(apps, schema_editor):
    if settings.DATABASES['default']['ENGINE'] not in (
        'django_pgaas.backend',
        'django.db.backends.postgresql',
    ):
        return
    Kpi = apps.get_model('core', 'Kpi')
    for kpi in Kpi.objects.all():
        kpi.name, year_quarter = kpi.name.rsplit(' ', 1)
        year, quarter = map(int, year_quarter.split('_Q'))
        kpi.year = year
        kpi.quarter = quarter
        kpi.save()


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0077_template_type_constraint'),
    ]

    operations = [
        migrations.AddField(
            model_name='kpi',
            name='quarter',
            field=models.SmallIntegerField(null=True),
        ),
        migrations.AddField(
            model_name='kpi',
            name='year',
            field=models.SmallIntegerField(null=True),
        ),
        migrations.RunPython(code=migrate),
    ]
