# -*- coding: utf-8 -*-
# Generated by Django 1.11.28 on 2022-02-21 12:18
from logging import getLogger

from django.db import migrations, models
import django.db.models.deletion

log = getLogger(__name__)


def move_data_from_umbrella_person_review(apps, schema_editor):
    UmbrellaPersonReview = apps.get_model('gradient', 'UmbrellaPersonReview')
    for upr in UmbrellaPersonReview.objects.select_related('person_review').order_by('-id'):
        if upr.person_review.main_product is None or upr.person_review.umbrella is None:
            upr.person_review.umbrella = upr.umbrella
            upr.person_review.main_product = upr.umbrella.main_product
            upr.person_review.save()
        else:
            log.warning(
                'Found not unique relation: id=%s, umbrella=%s, person=%s',
                upr.id, upr.umbrella_id, upr.person_review.person_id,
            )


class Migration(migrations.Migration):

    dependencies = [
        ('gradient', '0002_umbrellaperson'),
        ('core', '0081_move_umbrellas_model_to_gradient_app'),
    ]

    operations = [
        migrations.AddField(
            model_name='personreview',
            name='main_product',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='person_reviews', related_query_name='person_review', to='gradient.MainProduct'),
        ),
        migrations.AddField(
            model_name='personreview',
            name='umbrella',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='person_reviews', related_query_name='person_review', to='gradient.Umbrella'),
        ),
        migrations.RunPython(move_data_from_umbrella_person_review),
    ]
