# -*- coding: utf-8 -*-
# Generated by Django 1.11.28 on 2022-05-20 10:34
from __future__ import unicode_literals

from django.db import migrations, models


def migrate_deferred_payment_mode(apps, schema_editor):
    Review = apps.get_model('core', 'Review')
    reviews_with_deferred_payment = Review.objects.filter(
        status__in=('f', 'a'),
        bonus_mode='m',
        finish_date__year='2022',
    )
    reviews_with_deferred_payment.update(deferred_payment_mode='m')


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0084_deferred_null'),
    ]

    operations = [
        migrations.AddField(
            model_name='review',
            name='deferred_payment_mode',
            field=models.CharField(choices=[('d', 'disabled'), ('a', 'auto'), ('m', 'manual')], default='d', max_length=1, null=True),
        ),
        migrations.RunPython(migrate_deferred_payment_mode),
    ]
