# coding: utf-8
from io import BytesIO

from django import http
from django_ids import auth
from django import urls

from review.shortcuts import models


def get_response(
    path,
    login,
    get_params=None,
    post_params=None,
    json_data=None,
    return_data=False,
):
    """
    Get view result for user for debugging purposes.
    Result can be as HttpResponse or data from process_* method.
    >>> get_response('/frontend/reviews/247/', login='volozh')
    ... <JsonResponse status_code=403, "application/json">
    >>> get_response('/frontend/reviews/247/', login='volozh', return_data=True)
    ... PermissionDenied
    """
    user = models.Person.objects.get(login=login)

    request = http.HttpRequest()
    request.user = user
    request.auth = auth.Auth(
        user=user,
        login=login,
        uid=user.uid,
        staff_id=user.id,
    )

    if json_data is not None:
        request._stream = BytesIO(json_data)

    if get_params is not None:
        request.GET.update(get_params)

    if post_params is not None:
        request.POST.update(post_params)

    if post_params or json_data:
        request.method = 'POST'
    else:
        request.method = 'GET'

    resolver = urls.resolve(path)
    if return_data:
        handler = resolver.func.view_class().dispatch_process
    else:
        handler = resolver.func

    response = handler(request, *resolver.args, **resolver.kwargs)
    return response
