# coding: utf-8

import logging
import os
import psutil


log = logging.getLogger(__name__)


def configure(settings_module_path="review.settings"):
    os.environ.setdefault("DJANGO_SETTINGS_MODULE", settings_module_path)

    application = os.environ.get('QLOUD_APPLICATION') or os.environ.get('DEPLOY_PROJECT_ID')
    environment = os.environ.get('QLOUD_ENVIRONMENT') or os.environ.get('DEPLOY_STAGE_ID', '').rsplit('_', 1)[-1]

    log.warning(
        f'Loading settings yenv_type {os.environ.get("YENV_TYPE")} '
        f'app {application} env {environment}'
    )

    if 'YENV_TYPE' not in os.environ:
        if application == 'review-stands':
            yenv_type = 'testing'
            os.environ['IS_STAND'] = 'True'
        elif environment:
            yenv_type = environment
        else:
            yenv_type = 'development'
        os.environ['YENV_TYPE'] = yenv_type
    os.environ['YENV_NAME'] = 'intranet'

    # idk how to force celery to read settings
    # i guess there is better way of doing it
    from review import celery_app  # noqa: E402
    from review import error_booster  # noqa: E402

    error_booster.init()


def source_process_env(name):
    is_deploy = bool(os.environ.get('DEPLOY_PROJECT_ID'))
    if not is_deploy:
        return

    pid = None
    for proc in psutil.process_iter():
        if name == proc.name():
            pid = proc.pid
            break

    if not pid:
        return

    env_file = '/proc/{}/environ'.format(pid)
    if os.path.isfile(env_file):
        with open(env_file, 'r') as runtime_env:
            envspecs = runtime_env.read().split('\000')
        for envspec in envspecs:
            if envspec:
                env, val = envspec.split('=', 1)
                os.environ[env] = val
