import os
import sentry_sdk
import yenv
from django.conf import settings
from errorboosterclient.sentry import ErrorBoosterTransport
from errorboosterclient.uagent import UnifiedAgentSender
from sentry_sdk.integrations.django import DjangoIntegration


_enabled = False


def init():
    global _enabled
    if not settings.ENABLE_ERRORBOOSTER or _enabled:
        return
    sentry_sdk.init(
        transport=ErrorBoosterTransport(
            project=os.getenv('DEPLOY_STAGE_ID'),
            sender=UnifiedAgentSender(),
        ),
        integrations=[DjangoIntegration()],
        send_default_pii=True,

        environment=yenv.type,
        release='0.0.1',

        shutdown_timeout=20,
        with_locals=False,
    )
    _enabled = True
