# coding: utf-8
import logging

from review.core.logic import cia
from review.lib import views

logger = logging.getLogger(__name__)


class PersonReviewFeedbackView(views.View):

    def process_get(self, auth, data):
        feedback = cia.get_feedback_for_person_review(
            auth=auth,
            id=int(data['id']),
        )

        return dict(feedback=feedback)


class CalibrationPersonReviewFeedbackView(views.View):

    def process_get(self, auth, data):
        feedback = cia.get_feedback_for_calibration_person_review(
            auth=auth,
            id=data['id'],
        )
        return dict(feedback=feedback)
