# coding: utf-8
from typing import Set, Optional

import attr

from review.bi.logic import grade_lte_18
from review.core import const
from review.staff import (
    const as staff_const,
    models as staff_models,
)


# Это костыль и надо переделать на роль, но не хочется переделывать роли, пока не завершено review.
# https://st.yandex-team.ru/STAFF-14666
TOP_ANALYSTS = {
    'ekvoloboy',
    'ruzovag',
    'aaemelya',
    'evgpopkova',
    'raylyan',
}


@attr.s(slots=True)
class ForPerson(object):
    """
    Determines if data is available for current request's user
    For every requested person permissions can be different
    """
    oebs_data = attr.ib(type=bool, default=False)
    options_history = attr.ib(type=bool, default=False)
    show_excercisable = attr.ib(type=bool, default=False)
    has_not_vested = attr.ib(type=bool, default=False)
    not_vested = attr.ib(type=bool, default=False)


def get_for_person(
    subject: staff_models.Person,
    roles: Set[str],
    observable_login: str,
    grade: Optional[int]
) -> ForPerson:
    roles_can_see_oebs_data = {
        const.ROLE.PERSON.SELF,
        staff_const.STAFF_ROLE.DEPARTMENT.HEAD,
        staff_const.STAFF_ROLE.HR.HR_PARTNER,
        staff_const.STAFF_ROLE.HR.HR_ANALYST,
    }
    oebs_data = bool(roles & roles_can_see_oebs_data)

    is_only_analyst_role = roles == {staff_const.STAFF_ROLE.HR.HR_ANALYST}
    is_subject_top_analyst = subject.login in TOP_ANALYSTS
    forbid_access_to_options = is_only_analyst_role and not is_subject_top_analyst
    access_to_options = oebs_data and not forbid_access_to_options
    is_loan_viewer = const.ROLE.GLOBAL.LOAN_VIEWER in roles

    return ForPerson(
        oebs_data=oebs_data,
        options_history=access_to_options,
        show_excercisable=(subject.login == observable_login),
        has_not_vested=is_loan_viewer or access_to_options,
        not_vested=access_to_options or (is_loan_viewer and grade_lte_18(grade)),
    )
