# coding: utf-8
from review.lib.urls import url
from review.frontend.views import (
    actions,
    calibrations,
    calibrations_detail,
    calibrations_detail_extra,
    calibration_person_reviews,
    calibration_person_reviews_actions,
    comments,
    constants,
    export_file,
    goals,
    import_comments,
    import_file,
    import_umbrellas,
    log,
    marks,
    pending_tasks,
    persons,
    person_reviews,
    reviews,
    stored_filters,
    structure_changes,
    user,
    tags,
    gradient,
    kpi,
    derpartments,
)

URL_LOGIN_RE = '[\w-]+'


urlpatterns = [
    url(r'^const/$', constants.ConstView),
    url(r'^user/$', user.UserView),
    url(r'^structure-changes/$', structure_changes.StructureChangesView),
    url(r'^departments/$', derpartments.DepartmentNamesView),
    url(r'^marks-scales/$', marks.MarksScalesView),
    url(r'^tags-suggest/$', tags.TagsSuggestView),
    url(r'^umbrellas-suggest/$', gradient.UmbrellasSuggestView),
    url(r'^umbrellas-by-ids/$', gradient.UmbrellasByIdsView),
    url(r'^main-product-suggest/$', gradient.MainProductSuggestView),
    url(r'^main-product-by-ids/$', gradient.MainProductByIdsView),

    url(r'^reviews/$', reviews.ReviewListView),
    url(r'^reviews/(?P<id>\d+)/$', reviews.ReviewDetailView),
    url(r'^reviews/(?P<id>\d+)/load-kpi/$', reviews.ReviewLoadKpi),
    url(r'^reviews/(?P<id>\d+)/workflow/$', reviews.ReviewFollowWorkflowView),
    url(r'^reviews/(?P<id>\d+)/update-product-structure/$',
        reviews.UpdateProductStructureView),
    url(r'^reviews/(?P<id>\d+)/add-persons/$',
        person_reviews.ReviewSubjectAddView),
    url(r'^reviews/(?P<id>\d+)/delete-persons/$',
        person_reviews.ReviewSubjectDelView),
    url(r'^reviews/(?P<id>\d+)/person-reviews/$',
        person_reviews.ReviewPersonReviewsView),
    url(r'^reviews/(?P<id>\d+)/export/(?P<template_type>[\w-]+)/$',
        export_file.PersonReviewTemplateExportView),
    url(r'^reviews/(?P<id>\d+)/participants/pending-tasks/$', pending_tasks.ReviewParticipantsTasksView),

    url(r'^reviews/pending-tasks/$', pending_tasks.ReviewPendingTasksView),

    url(r'^persons/(?P<login>%s)/log/$' % URL_LOGIN_RE, log.PersonLogView),
    url(r'^persons/(?P<login>%s)/active-calibrations/$' % URL_LOGIN_RE,
        persons.PersonActiveCalibrationsView),
    url(r'^persons/(?P<login>%s)/umbrellas/$' % URL_LOGIN_RE,
        gradient.PersonUmbrellasView),

    url(r'^persons/$', persons.PersonNamesView),

    url(r'^person-reviews-mode-review/$',
        person_reviews.PersonReviewsModeReviewView),
    url(r'^person-reviews/ids-only/$',
        person_reviews.PersonReviewsModeReviewIdsOnlyView),
    url(r'^person-reviews-mode-history/$',
        person_reviews.PersonReviewsHistoryView),

    url(r'^person-reviews/bulk/actions/$', actions.ActionBulkView),
    url(r'^person-reviews/(?P<id>\d+)/actions/$', actions.ActionDetailView),

    url(r'^person-reviews/(?P<id>\d+)/comments/$',
        comments.PersonReviewCommentsView),
    url(r'^person-reviews/(?P<id>\d+)/comments/(?P<comment_id>\d+)/$',
        comments.PersonReviewCommentsDetailView),

    url(r'^person-reviews/(?P<id>\d+)/goals/$',
        goals.PersonReviewGoalsView),

    url(r'^person-reviews/(?P<id>\d+)/kpi/$',
        kpi.PersonReviewKpiView),

    url(r'^person-reviews/export/(?P<format>csv|xls)/$',
        export_file.PersonReviewExportView),
    url(r'^person-reviews/export-comments/$',
        export_file.CommentsExportView),
    url(r'^person-reviews/import/$',
        import_file.PersonReviewImportView),
    url(r'^person-reviews/import/csv/$',
        import_file.PersonReviewImportView),
    url(r'^person-reviews/import/xls/$',
        import_file.PersonReviewImportView),
    url(r'^import/$',
        import_comments.upload_comments),
    url(r'^import/comments/$',
        import_comments.BonusCommentView),

    # FIXME CIA-2917 исправить эти вьюхи на новую схему или удалить совсем
    url(r'^import_umbrellas/$',
        import_umbrellas.import_umbrellas),
    url(r'^import_umbrellas/upload/$',
        import_umbrellas.ImportUmbrellasUploadView),
    # FIXME END

    url(r'^stored-filters/$', stored_filters.StoredFiltersView),
    url(r'^stored-filters/(?P<id>\d+)/$', stored_filters.StoredFiltersDetailView),

    url(r'^calibrations/$', calibrations.CalibrationList),
    url(r'^calibrations/suggest/$', calibrations.CalibrationSuggestView),

    url(r'^calibrations/(?P<id>\d+)/$', calibrations_detail.CalibrationDetailView),
    url(r'^calibrations/(?P<id>\d+)/pending-tasks/$', pending_tasks.CalibrationPendingTasksView),
    url(r'^calibrations/(?P<id>\d+)/workflow/$', calibrations_detail.CalibrationFollowWorkflowView),
    url(r'^calibrations/(?P<id>\d+)/copy/$', calibrations_detail.CalibrationCopyView),

    url(r'^calibrations/(?P<id>\d+)/calibrators/$',
        calibrations_detail_extra.CalibrationCalibratorsView),
    url(r'^calibrations/(?P<id>\d+)/recommended-calibrators/$',
        calibrations_detail_extra.CalibrationRecommendedCalibratorsView),
    url(r'^calibrations/(?P<id>\d+)/add-calibrators/$',
        calibrations_detail_extra.CalibrationAddCalibratorsView),
    url(r'^calibrations/(?P<id>\d+)/delete-calibrators/$',
        calibrations_detail_extra.CalibrationDeleteCalibratorsView),
    url(r'^calibrations/(?P<id>\d+)/admins/$',
        calibrations_detail_extra.CalibrationAdminsView),
    url(r'^calibrations/(?P<id>\d+)/add-admins/$',
        calibrations_detail_extra.CalibrationAddAdminsView),
    url(r'^calibrations/(?P<id>\d+)/delete-admins/$',
        calibrations_detail_extra.CalibrationDeleteAdminsView),

    url(r'^calibrations/(?P<id>\d+)/add-persons/$',
        calibration_person_reviews.CalibrationAddPersonsView),
    url(r'^calibrations/(?P<id>\d+)/add-person-reviews/$',
        calibration_person_reviews.CalibrationAddPersonReviewsView),
    url(r'^calibrations/(?P<id>\d+)/delete-calibration-person-reviews/$',
        calibration_person_reviews.CalibrationDeletePersonReviewView),

    url(r'^calibrations/(?P<id>\d+)/mode-calibration/$',
        calibration_person_reviews.CalibrationModeCalibrationView),
    url(r'^calibrations/(?P<id>\d+)/mode-edit/$',
        calibration_person_reviews.CalibrationModeEditView),

    url(r'^calibration-person-reviews/history/$',
        calibrations_detail_extra.CalibrationPersonReviewsHistoryView),
    url(r'^calibration-person-reviews/bulk/actions/$',
        calibration_person_reviews_actions.CalibrationPersonReviewBulkActionView),
    url(r'^calibration-person-reviews/(?P<id>\d+)/actions/$',
        calibration_person_reviews_actions.CalibrationPersonReviewDetailActionView),
]
