# coding: utf-8
import collections
import waffle
from django.db.models import F

from review.lib import views
from review.shortcuts import const
from review.oebs import models as oebs_models


class ConstView(views.View):

    def process_get(self, auth, data):
        currency_keys = oebs_models.Currency.objects.values_list(
            'key', flat=True
        )
        professions = oebs_models.Profession.objects.annotate(
            name=F('name_' + auth.user.language)
        ).values_list('key', 'name')
        professions = collections.OrderedDict(professions)
        return {
            'review_status': list(const.REVIEW_STATUS.VERBOSE.values()),
            'options_rsu_unit': list(const.REVIEW_OPTIONS_RSU_UNIT.VERBOSE.values()),
            'goldstar': list(const.GOLDSTAR.VERBOSE.values()),
            'person_review_status': list(const.PERSON_REVIEW_STATUS.VERBOSE.values()),
            'marks_special_values': const.MARK.SPECIAL_VALUES,
            'profession': professions,
            'currency': list(currency_keys),
            'mark_mode': sorted(const.REVIEW_MODE.FORM_CHOICE_FOR_MARK_MODE),
            'review_type': list(const.REVIEW_TYPE.VERBOSE.values()),
            'waffle': {
                'prevent_page_reload': waffle.switch_is_active("prevent_page_reload"),
                'calibration_auto_update': waffle.switch_is_active("calibration_auto_update"),
            },
            'review_notify_reminder_days': const.WEEK_DAYS,
        }
