from review.lib import views
from django import forms
from review.staff import models as staff_models


class DepartmentNamesForm(forms.Form):
    slugs = forms.ModelMultipleChoiceField(
        queryset=staff_models.Department.objects.all(),
        required=True,
        to_field_name='slug'
    )


class DepartmentNamesView(views.View):

    form_cls_get = DepartmentNamesForm

    def process_get(self, auth, data):
        lang = auth.user.language

        return {
            department.slug: getattr(department, 'name_' + lang, 'slug')
            for department in list(data['slugs'])
        }
