# coding: utf-8
import logging

from review.core.logic import cia
from review.lib import views


logger = logging.getLogger(__name__)


class PersonReviewGoalsView(views.View):
    def process_get(self, auth, data):
        result = {}
        try:
            result['goals'] = cia.get_goals(
                auth=auth,
                person_review_id=int(data['id']),
            )
        except Exception as exc:
            logger.exception(exc)
            result['errors'] = str(exc)

        return result
