from django.http import HttpResponse
from django.shortcuts import render
from django.template import Template, RequestContext

from review.frontend.views.import_file import *


class BonusCommentFileForm(forms.Form):
    data_file = forms.FileField()
    text_tmpl = forms.CharField()

    def clean(self):
        if not self.is_valid():
            raise ValidationError(self.errors)
        cleaned = super(BonusCommentFileForm, self).clean()
        serialized_file = lib_serializers.serialize_file_sheet(cleaned['data_file'])
        return {
            'updates': {
                int(row.pop('id')): {'comment': cleaned['text_tmpl'].format(**row)}
                for row in serialized_file
            }
        }


class BonusCommentView(PersonReviewImportView):
    form_cls_post = BonusCommentFileForm


def upload_comments(request):
    tmpl = Template('''
    <form action='comments/' method='POST' enctype='multipart/form-data'>
    {% csrf_token %}
    {{ form }}
    <input type='submit' value='Submit'>
    </form>
    ''')
    context = RequestContext(request, {'form': BonusCommentFileForm()})
    return HttpResponse(tmpl.render(context))
