from review.core.logic import assemble
from review.lib import (
    views,
)
import logging
from review.shortcuts import const
from review.shortcuts import models
from review.shortcuts import serializers
from django import http


logger = logging.getLogger(__name__)

Serializer = serializers.KpiSerializer


class PersonReviewKpiView(views.View):

    def process_get(self, auth, data):
        person_review = assemble.get_person_review(
            subject=auth.user,
            fields_requested={
                const.FIELDS.ID,
            },
            id=int(data['id']),
            role_types=const.ROLE.PERSON_REVIEW_LIST_RELATED | const.ROLE.CALIBRATION.ALL,
        )

        serialized = {}

        if person_review is None:
            raise http.Http404('person review with id %s not found' % data['id'])

        kpis = models.Kpi.objects.filter(person_review=person_review.id)

        return {'kpi': Serializer.serialize_many(kpis)}
