# coding: utf-8
from django import forms

from review.core import models, const
from review.lib import views
from review.lib import forms as lib_forms
from review.shortcuts import models


class MarksScalesForm(forms.Form):
    reviews = forms.ModelMultipleChoiceField(
        queryset=models.Review.objects.filter(
            status__in=const.REVIEW_STATUS.VISIBLE,
        ),
        required=False,
    )
    review_activity = lib_forms.NiceNullBooleanField(
        required=False,
    )


class MarksScalesView(views.View):
    form_cls_get = MarksScalesForm

    def process_get(self, auth, data):
        query_params = {}
        review_activity = data.get('review_activity')
        if review_activity is not None:
            if review_activity:
                query_params['review__status__in'] = const.REVIEW_STATUS.ACTIVE
            else:
                query_params['review__status__in'] = const.REVIEW_STATUS.INACTIVE
        if data.get('reviews'):
            query_params['review__id__in'] = data.get('reviews')

        scales = models.MarksScale.objects.all()
        if query_params:
            scales = scales.filter(**query_params)
        return dict(marks_scales=[
            dict(
                id=it.id,
                scale=it.scale,
                show_absolute=it.show_absolute,
                use_colors=it.use_colors,
                version=it.version,
            )
            for it in scales
        ])
