import attr
import waffle
from django import forms

from review.core import (
    task_api,
)
from review.lib import (
    views,
)


class ReviewPendingTasksForm(forms.Form):

    review_activity = forms.BooleanField(
        required=False
    )
    review = forms.IntegerField(
        required=False,
    )

    def clean(self):
        cleaned_data = super(ReviewPendingTasksForm, self).clean()
        if not cleaned_data:
            raise forms.ValidationError('Need to choose filtering')
        return cleaned_data


class ReviewPendingTasksView(views.View):
    form_cls_get = ReviewPendingTasksForm

    def process_get(self, auth, data):
        review_id = data.get('review')
        enable_active_review_api = waffle.switch_is_active(
            'enable_pending_tasks_api_for_active_review_page',
        )
        enable_review_id_api = waffle.switch_is_active(
            'enable_pending_tasks_api_for_review_by_id_page',
        )
        if not review_id and enable_active_review_api:
            res = task_api.get_active_reviews_pending_tasks(auth.user)
        elif enable_review_id_api:
            res = task_api.get_review_pending_tasks(auth.user, review_id)
        else:
            res = task_api.PersonReviewTableTasks()
        return {'active_tasks': attr.asdict(res)}


class ReviewParticipantsTasksView(views.View):

    def process_get(self, auth, data):
        review_id = data.get('id')
        enable_api = waffle.switch_is_active(
            'enable_pending_tasks_api_for_review_participants_page',
        )
        if enable_api:
            res = task_api.get_review_participants_pending_tasks(
                auth.user,
                review_id,
            )
        else:
            res = []
        return {'active_tasks': {task_api.PENDING_EVENT_TYPES.REVIEWERS_CHANGE: res}}


class CalibrationPendingTasksView(views.View):

    def process_get(self, auth, data):
        calibration_id = data.get('id')
        enable_api = waffle.switch_is_active(
            'enable_pending_tasks_api_for_calibration_page',
        )
        if enable_api:
            res = task_api.get_calibration_pending_tasks(
                auth.user,
                calibration_id,
            )
        else:
            res = task_api.PersonReviewTableTasks()
        return {'active_tasks': attr.asdict(res)}
