# coding: utf-8
from review.lib import views
from review.shortcuts import models


class StructureChangesView(views.View):

    def process_get(self, auth, data):
        return {'structure_changes': list(
            models.StaffStructureChange.objects
            .order_by('-date', '-created_at_auto')
            .distinct('date')
            .filter(id__in=models.PersonHeads.objects.values('structure_change_id'))
            .values('id', 'date', 'staff_id')
        )}
