# coding: utf-8
from django import forms

from review.lib import views
from review.shortcuts import models


class TagsSuggestForm(forms.Form):
    text = forms.CharField()


class TagsSuggestView(views.View):
    form_cls_get = TagsSuggestForm

    def process_get(self, auth, data):
        query = (
            models.PersonReview.objects
            .values_list('tag_average_mark', flat=True)
            .distinct()
            .filter(tag_average_mark__icontains=data['text'])
        )
        return [dict(value=it) for it in query]
