from django.contrib import admin

from review.lib.admin import ReadOnlyProductionModelAdmin
from review.gradient import models


@admin.register(models.MainProduct)
class MainProductAdmin(ReadOnlyProductionModelAdmin):
    fields = (
        'name',
        'abc_service_id',
        'issue_key',
    )
    list_display = fields

    def has_add_permission(self, request):
        return True

    def save_model(self, request, obj, form, change) -> None:
        # we can't save as empty strings due them being unique=True
        if not obj.issue_key:
            obj.issue_key = None
        if not obj.abc_service_id:
            obj.abc_service_id = None
        return super().save_model(request, obj, form, change)


@admin.register(models.Umbrella)
class UmbrellaAdmin(ReadOnlyProductionModelAdmin):
    fields = (
        'issue_key',
        'name',
        'main_product',
    )
    list_display = fields
    raw_id_fields = (
        'main_product',
    )


@admin.register(models.UmbrellaPerson)
class UmbrellaPersonAdmin(ReadOnlyProductionModelAdmin):
    fields = (
        'umbrella',
        'person',
        'engagement',
        'engaged_from',
        'engaged_to',
    )
    list_display = fields
    raw_id_fields = ('person', 'umbrella')


@admin.register(models.MainProductPerson)
class MainProductPersonAdmin(ReadOnlyProductionModelAdmin):
    fields = (
        'main_product',
        'person',
        'engaged_from',
        'engaged_to',
    )
    list_display = fields
    raw_id_fields = ('person', 'main_product')
