# -*- coding: utf-8 -*-
# Generated by Django 1.11.28 on 2022-02-18 09:06
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('core', '0081_move_umbrellas_model_to_gradient_app'),
    ]

    operations = [
        migrations.CreateModel(
            name='MainProduct',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('issue_key', models.CharField(max_length=255, unique=True)),
                ('name', models.CharField(max_length=255)),
                ('abc_service_id', models.IntegerField(null=True)),
            ],
            options={
                'db_table': 'core_mainproduct',
            },
        ),
        migrations.CreateModel(
            name='MainProductReview',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('main_product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='main_product_reviews', related_query_name='main_product_review', to='gradient.MainProduct')),
                ('review', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='main_product_reviews', related_query_name='main_product_review', to='core.Review')),
            ],
            options={
                'db_table': 'core_mainproductreview',
            },
        ),
        migrations.CreateModel(
            name='Umbrella',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('issue_key', models.CharField(max_length=255, unique=True)),
                ('name', models.CharField(max_length=255)),
                ('main_product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='umbrellas', related_query_name='umbrella', to='gradient.MainProduct')),
            ],
            options={
                'db_table': 'core_umbrella',
            },
        ),
        migrations.CreateModel(
            name='UmbrellaPersonReview',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('person_review', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='umbrella_person_reviews', related_query_name='umbrella_person_review', to='core.PersonReview')),
                ('umbrella', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='umbrella_person_reviews', related_query_name='umbrella_person_review', to='gradient.Umbrella')),
            ],
            options={
                'db_table': 'core_umbrellapersonreview',
            },
        ),
        migrations.CreateModel(
            name='UmbrellaReview',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('review', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='umbrella_reviews', related_query_name='umbrella_review', to='core.Review')),
                ('umbrella', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='umbrella_reviews', related_query_name='umbrella_review', to='gradient.Umbrella')),
            ],
            options={
                'db_table': 'core_umbrellareview',
            },
        ),
        migrations.AlterUniqueTogether(
            name='umbrellareview',
            unique_together=set([('review', 'umbrella')]),
        ),
        migrations.AlterUniqueTogether(
            name='umbrellapersonreview',
            unique_together=set([('person_review', 'umbrella')]),
        ),
        migrations.AlterUniqueTogether(
            name='mainproductreview',
            unique_together=set([('review', 'main_product')]),
        ),
    ]
