from review.lib.serializers import BaseSerializer, F


class MainProductSerializer(BaseSerializer):
    fields = {
        'id',
        'name',
        'abc_service_id',
    }


class UmbrellaSerializer(BaseSerializer):
    fields = {
        'id',
        'name',
        'issue_key',
        F('main_product', source='get_main_product()'),
    }

    @classmethod
    def get_main_product(cls, obj):
        if not obj.main_product:
            return None
        return MainProductSerializer.serialize(obj.main_product)


class UmbrellaPersonSerializer(BaseSerializer):
    fields = {
        F('engagement', cast_type=float),
        'engaged_from',
        'engaged_to',
        F('umbrella', complex=UmbrellaSerializer),
    }
