from django.contrib import admin
from django.conf import settings


class ReadOnlyProductionAdminMixin:
    def get_readonly_fields(self, *args, **kwargs):
        if settings.IS_PRODUCTION_DB:
            return self.fields
        else:
            return super(ReadOnlyProductionAdminMixin, self).get_readonly_fields(*args, **kwargs)

    def has_delete_permission(self, request, obj=None):
        return not settings.IS_PRODUCTION_DB

    def has_add_permission(self, request):
        return not settings.IS_PRODUCTION_DB


class ReadOnlyProductionModelAdmin(ReadOnlyProductionAdminMixin, admin.ModelAdmin):
    pass
