# coding: utf-8
import datetime
import arrow


def now():
    return arrow.now().datetime


def today():
    return now().date()


def shifted(dt, **shift):
    shifted_datetime = arrow.get(dt).replace(**shift)
    # isinstance(date, datetime.date) returns True for datetimes
    if is_date(dt):
        return shifted_datetime.date()
    if is_naive(dt):
        return shifted_datetime.naive
    return shifted_datetime.datetime


def is_date(dt):
    if type(dt) is datetime.date:
        return True
    if isinstance(dt, str) and len(dt) == len('2018-01-01'):
        return True
    return False


def is_naive(dt):
    if type(dt) is datetime.datetime and dt.tzinfo is None:
        return True
    if isinstance(dt, str) and len(dt) == len('2018-01-01T12:00:00'):
        return True
    return False

replaced = shifted
