# coding: utf-8
import fnmatch

from django.conf import settings
from debug_toolbar.middleware import show_toolbar


def optional_show_toolbar(request):
    for ignored_path in settings.HIDE_TOOLBAR_PATHS:
        if fnmatch.fnmatchcase(request.path_info, ignored_path):
            return False
    else:
        return show_toolbar(request)
