# coding: utf-8
from django import forms


class NiceNullBooleanField(forms.NullBooleanField):
    widget = forms.Widget


def parse_choices(choices):
    if isinstance(choices, dict):
        choices = list(choices.items())
    verbose_to_short = {verbose: short for short, verbose in choices}
    verbose_choices = [(short, short) for short, verbose in choices]
    return verbose_to_short, verbose_choices


class VerboseChoiceField(forms.ChoiceField):
    def __init__(self, choices, **kwargs):
        self.verbose_to_short, verbose_choices = parse_choices(choices)
        super(VerboseChoiceField, self).__init__(choices=verbose_choices, **kwargs)

    def to_python(self, value):
        value = super(VerboseChoiceField, self).to_python(value)
        return self.verbose_to_short.get(value, '')


class VerboseMultipleChoiceField(forms.MultipleChoiceField):
    def __init__(self, choices, **kwargs):
        self.verbose_to_short, verbose_choices = parse_choices(choices)
        super(VerboseMultipleChoiceField, self).__init__(choices=verbose_choices, **kwargs)

    def to_python(self, value):
        value = super(VerboseMultipleChoiceField, self).to_python(value)
        value = (self.verbose_to_short.get(v) for v in value)
        return [v for v in value if v is not None]
