# coding: utf-8
from django.utils import translation

from review.lib.auth import has_real_user


class SetLanguageMiddleware(object):

    def process_request(self, request):
        """
        Проставляем актуальное значение языка из паспорта — при изменении
        на стаффе оттуда мы получим его сразу, а из staff-api
        после синхронизации.

        Возможно не очень хорошо изменять существующий в базе параметр
        таким образом, но в коде удобно иметь прямо в пользовтеле
        его актуальный язык, кажется не должно вызвать много вопросов.
        """
        user = request.auth.user

        if user is None or not has_real_user(request):
            return

        yauser = request.auth.yauser

        accept_language = request.META.get('HTTP_ACCEPT_LANGUAGE')
        if accept_language and accept_language.lower() in ('ru', 'en'):
            user.language = accept_language
        elif 'language' in getattr(yauser, 'fields', []):
            user.language = yauser.fields['language']
        translation.activate(user.language)
