# coding: utf-8

from celery import shared_task
from django.conf import settings
import ylock
from ylock import decorators
import yenv


manager = ylock.backends.create_manager(**settings.YLOCK)


def get_lock_or_do_nothing(func):
    name = func.__name__
    return decorators.locked(name, manager)(func)


def get_lock_or_do_nothing_task(*args, **shared_task_kwargs):
    assert len(args) < 2, 'Only kwargs can be passed to shared_task'

    def deco(func):
        name = func.__name__
        if yenv.type != 'development':
            func = decorators.locked(name, manager)(func)
        return shared_task(func, **shared_task_kwargs)

    if args:
        return deco(args[0])
    return deco
