from django_yauth.user import YandexUser
from django_yauth.authentication_mechanisms.base import BaseMechanism


class FetchLoginAuthBackend(BaseMechanism):

    def is_applicable(self, request):
        # returns params for self.apply
        # if res is None - middleware skips current mechanism
        login = self.fetch_login(request)
        if login:
            return {'login': login}

    def apply(self, login):
        return YandexUser(
            uid=None,
            fields={
                'login': login,
            }
        )

    def fetch_login(self, request):
        raise NotImplementedError
