# coding: utf-8

import inspect

from django.core import urlresolvers
from django.conf import settings
from django.utils import six

from django_replicated import middleware
from django_replicated.utils import get_object_name


class ReplicationMiddleware(middleware.ReplicationMiddleware):

    def check_state_override(self, request, state):
        if request.COOKIES.get(
                settings.REPLICATED_FORCE_MASTER_COOKIE_NAME) == 'true':
            return 'master'

        overrides = settings.REPLICATED_VIEWS_OVERRIDES

        if overrides:
            match = urlresolvers.resolve(request.path_info)

            import_path = '%s.%s' % (get_object_name(inspect.getmodule(match.func)),
                                     get_object_name(match.func))

            for lookup_view, forced_state in six.iteritems(overrides):
                if (
                    match.url_name == lookup_view or
                    import_path == lookup_view or
                    self._is_path_matched(request.path_info, lookup_view)
                ):
                    state = forced_state
                    break
        return state

    @staticmethod
    def _is_path_matched(path_info, lookup):
        if lookup.endswith('*'):
            return path_info.startswith(lookup[:-len('*')])
        else:
            return path_info == lookup
