from storages.backends.s3boto3 import S3Boto3Storage, boto3

from review import settings
from review.lib.tvm2_client import get_tvm2_boto3_session, get_service_ticket
from review.lib.urls import remove_query_param


class S3Storage(S3Boto3Storage):
    def url(self, *args, **kwargs):
        url = super(S3Storage, self).url(*args, **kwargs)

        return remove_query_param(url, 'AWSAccessKeyId')

    @property
    def connection(self):
        session = get_tvm2_boto3_session(settings.TVM_APP_SELF_ID, settings.TVM_APP_IDS['s3'])
        service_ticket = get_service_ticket(settings.TVM_APP_IDS['s3'])

        self._connection = session.resource(
            's3',
            aws_access_key_id=self.access_key,
            aws_session_token='TVM2 {}'.format(service_ticket),
            aws_secret_access_key='',
            region_name=self.region_name,
            use_ssl=self.use_ssl,
            endpoint_url=self.endpoint_url,
            config=self.config
        )

        return self._connection
