# coding: utf-8

import operator
from collections import OrderedDict


def remove_adjacent_doubles(list_):
    prev = object()
    new_list = []
    for item in list_:
        if item == prev:
            continue
        new_list.append(item)
        prev = item
    list_[:] = new_list


def group_by_attr(list_, key):
    return group_by(list_, key, getter=operator.attrgetter)


def group_by_item(list_, key):
    return group_by(list_, key, getter=operator.itemgetter)


def group_by(list_, key, getter):
    result = {}
    key_getter = getter(key)
    for item in list_:
        value = key_getter(item)
        item_group = result.setdefault(value, [])
        item_group.append(item)
    return result


def safe_itemgetter(dict_, keys_chain, default=None):
    """
    Безопасно получить значение из вложенного дикта без KeyError.
    safe_itemgetter(
        {'city': {'name': {'en': 'wat'}}},
        'city.name.ru',
    ) --> None
    safe_itemgetter(
        {'city': {'name': {'en': 'wat'}}},
        'city.name.en',
    ) --> 'wat'
    """
    if isinstance(keys_chain, str):
        keys_chain = keys_chain.split('.')

    subvalue = dict_
    for key in keys_chain:
        if not isinstance(subvalue, dict) or key not in subvalue:
            return default
        else:
            subvalue = subvalue[key]
    return subvalue


def subdict(
    dict_,
    filter_func,
    transform_func=lambda k, v: (k, v),
    remove_keys=False,
):
    result = {}
    for key, value in list(dict_.items()):
        if filter_func(key, value):
            new_key, new_value = transform_func(key, value)
            result[new_key] = new_value
            if remove_keys:
                del dict_[key]
    return result


def updated(dict_, **kwargs):
    result = dict_.copy()
    result.update(kwargs)
    return result


def subdict_by_key_prefix(dict_, prefix, **kwargs):
    return subdict(
        dict_=dict_,
        filter_func=lambda k, v: k.startswith(prefix),
        transform_func=lambda k, v: (k[len(prefix):], v),
        **kwargs
    )


def bulk_del_keys(dict_, keys):
    for key in keys:
        del dict_[key]
