# coding: utf-8
import inspect
import urllib.parse

from django.conf.urls import url as django_url
from django import views


def url(regex, view, *args, **kwargs):
    """Для тех, кто не любит писать as_view"""
    if inspect.isclass(view) and issubclass(view, views.View):
        view = view.as_view()
    return django_url(regex, view, *args, **kwargs)


def remove_query_param(url, param):
    """
    Does NOT support complex cases,
    see tests/lib/test_urls.py for examples
    """
    url_split = urllib.parse.urlsplit(url)
    params = urllib.parse.parse_qs(url_split.query)
    if param not in params:
        return url

    del params[param]
    query = urllib.parse.urlencode({k: v[0] if type(v) == list and len(v) == 1 else v
                                    for k, v in params.items()})
    return urllib.parse.urlunsplit(url_split[:3] + (query,) + url_split[4:])
