# coding: utf-8
import yenv
from ids.connector import http

from django.conf import settings


class WikiConnector(http.HttpConnector):
    url_patterns = dict(html='/v5/html')
    default_connect_timeout = 10

    @property
    def config(self):
        return yenv.choose_key_by_type(
            dict_={
                'testing': {
                    'protocol': 'https',
                    'host': 'wf.test.yandex-team.ru',
                },
                'production': {
                    'protocol': 'https',
                    'host': 'wf.yandex-team.ru',
                },
            },
            fallback=True,
        )


def format_markup(text, connector=None):
    connector = connector or WikiConnector(user_agent=settings.SERVICE)
    return connector.post(
        resource='html',
        data=dict(text=text),
        headers={'Content-Type': 'application/x-www-form-urlencoded'}
    ).text


def format_markup_bulk(texts):
    connector = WikiConnector(user_agent=settings.SERVICE)
    return {
        text: format_markup(text, connector=connector)
        for text in set(texts)
    }
