# coding: utf-8

from django.db import transaction

from review.core import models as core_models
from review.notifications import builders
from review.notifications import fetchers
from review.notifications import mailing
from review.notifications import helpers


@transaction.atomic
def create_notifications_for_person_review_changes(minutes=None):
    fetched = fetchers.fetch_changes_for_period(minutes)
    built = builders.build_notifications_for_person_review_changes(fetched)
    helpers.mark_notified(core_models.PersonReviewChange, ids=built['success_ids'])
    return mailing.save_email_models(built['notifications']), len(fetched)


@transaction.atomic
def create_notifications_for_person_review_comments(minutes=None):
    fetched = fetchers.fetch_comments_for_period(minutes)
    built = builders.build_notifications_for_person_review_comments(fetched)
    helpers.mark_notified(core_models.PersonReviewComment, ids=built['success_ids'])
    return mailing.save_email_models(built['notifications']), len(fetched)


@transaction.atomic
def create_notifications_for_review_reminders(reviews=None):
    fetched = fetchers.fetch_data_for_reviews_reminders(reviews)
    built = builders.build_notifications_for_review_reminders(fetched)
    return mailing.save_email_models(built['notifications'])


@transaction.atomic
def create_notification_for_added_calibrators():
    fetched = fetchers.fetch_data_for_added_calibrators()
    built = builders.build_notifications_for_added_calibrators(fetched)
    helpers.mark_notified(core_models.CalibrationRole, ids=built['success_ids'])
    return mailing.save_email_models(built['notifications'])
