# coding: utf-8

import yenv
import logging

from django.conf import settings
from post_office import models as post_office_models

_logger = logging.getLogger(__name__)


def save_email_models(notifications):
    models = list(map(build_email_model, notifications))
    return post_office_models.Email.objects.bulk_create(models)


def build_email_model(notification):
    subject = notification.get_subject()
    body = notification.get_body()
    to = notification.get_to()
    cc = notification.get_cc()
    bcc = notification.get_bcc()
    from_email = notification.get_from()
    headers = notification.get_headers()
    # for debug/test purposes, body already rendered
    # context should be jsonifiable
    context = notification.get_debug_context()
    if yenv.type not in ('production', 'prestable'):
        body += '<br/>\nOriginal To: {}'.format(to)
        if cc:
            body += '<br>\nCC: {}'.format(cc)
        if bcc:
            body += '<br>\nBCC: {}'.format(bcc)
        to = [settings.DEBUG_EMAIL]
        cc = []
        bcc = []

    headers['Reply-to'] = settings.EMAIL_REPLY_TO

    return post_office_models.Email(
        from_email=from_email,
        to=to,
        cc=cc,
        bcc=bcc,
        subject=subject,
        html_message=body,
        headers=headers,
        context=context,
        status=post_office_models.STATUS.queued,
    )
