from django.db import models
from post_office import models as post_office_models


RETRIES_NUMBER = 5


class EmailRetryCount(models.Model):
    email = models.OneToOneField(
        to=post_office_models.Email,
        related_name='retry_counter',
        related_query_name='retry_counter',
    )
    counter = models.PositiveSmallIntegerField(default=RETRIES_NUMBER - 1)
