# coding: utf-8
from review.lib.serializers import BaseSerializer, F


class PersonSerializer(BaseSerializer):
    fields = {
        'id',
        'login',
        'is_dismissed',
        'gender',
        F('first_name', source='first_name_?language?'),
        F('last_name', source='last_name_?language?'),
    }

    default_fields = {
        'id',
        'login',
        'gender',
        'first_name',
        'last_name',
    }


class ReviewSerializer(BaseSerializer):
    fields = {
        'id',
        'name',
        'finish_submission_date',
        'finish_approval_date',
    }

    default_fields = {
        'id',
        'name',
    }


class PersonReviewSerializer(BaseSerializer):
    fields = {
        'id',
        F('person', complex=PersonSerializer),
        F('review', complex=ReviewSerializer),
        # избыточность для удобства в шаблонах (нужна или запутывает?)
        # 'review_id',
        # F('person_login', source='person.login')
    }


class CalibrationSerializer(BaseSerializer):
    fields = {
        'id',
        'name',
        'start_date',
        'finish_date',
    }
