from post_office.models import (
    Email,
    STATUS,
)

from review.lib import datetimes


def get_stat():
    now = datetimes.now()
    not_sent = Email.objects.filter(
        created__gte=datetimes.shifted(now, hours=-36),
        created__lte=datetimes.shifted(now, hours=-13),
        status=STATUS.failed,
    ).count()
    return [
        ['notifications_not_sent_max', not_sent],
    ]
