# coding: utf-8
from copy import deepcopy

from django import http
from django.shortcuts import reverse

from review.lib import std
from review.notifications import notifications
from review.notifications import mailing


def get_tpl_to_notification():
    mapping = {}
    for symbol in dir(notifications):
        if not symbol.endswith('Notification'):
            continue
        if symbol == 'PersonalNotification':
            continue
        cls = getattr(notifications, symbol)
        mapping.update({
            cls.body_template + '_ru': cls,
            cls.body_template + '_en': cls,
        })
    return mapping


def templates_list(request):
    tpl_to_notification = get_tpl_to_notification()
    response_str = '\n'.join(
        '<a href="%s">%s</a><br/>' % (
            reverse(
                viewname=get_rendered_body,
                kwargs={
                    'template_name': template_name,
                },
            ),
            template_name,
        )
        for template_name in sorted(tpl_to_notification)
    )
    return http.HttpResponse(response_str)


def get_rendered_body(request, template_name):
    tpl_to_notification = get_tpl_to_notification()
    notification_cls = tpl_to_notification[template_name]

    language = template_name[-len('ru'):]
    context = deepcopy(DEV_CONTEXT[template_name])
    context['language'] = language
    notification = notification_cls(
        receiver=request.auth.user,
        context=DEV_CONTEXT[template_name],
    )
    notification.language = language

    if 'send' in request.GET:
        _send_notification(notification)

    return http.HttpResponse(notification.get_body())


def _send_notification(notification):
    email_model = mailing.build_email_model(notification)
    email_model.id = 1
    django_email_message = email_model.prepare_email_message()
    return django_email_message.send()


MALE_PERSON_ONE_LOGIN = 'volozh'
MALE_PERSON_ONE_RU = {
    'login': MALE_PERSON_ONE_LOGIN,
    'first_name': 'Аркадий',
    'last_name': 'Волож',
    'gender': 'm',
}
MALE_PERSON_ONE_EN = {
    'login': MALE_PERSON_ONE_LOGIN,
    'first_name': 'Arkady',
    'last_name': 'Volozh',
    'gender': 'm',
}
MALE_PERSON_TWO_LOGIN = 'imperator'
MALE_PERSON_TWO_RU = {
    'login': MALE_PERSON_TWO_LOGIN,
    'first_name': 'Михаил',
    'last_name': 'Парахин',
    'gender': 'm',
}
MALE_PERSON_TWO_EN = {
    'login': MALE_PERSON_TWO_LOGIN,
    'first_name': 'Mihail',
    'last_name': 'Parakhin',
    'gender': 'm',
}
MALE_PERSON_THREE_LOGIN = 'styskin'
MALE_PERSON_THREE_RU = {
    'login': MALE_PERSON_THREE_LOGIN,
    'first_name': 'Андрей',
    'last_name': 'Стыскин',
    'gender': 'm',
}
MALE_PERSON_THREE_EN = {
    'login': MALE_PERSON_THREE_LOGIN,
    'first_name': 'Andrey',
    'last_name': 'Styskin',
    'gender': 'm',
}
FEMALE_PERSON_ONE_LOGIN = 'bunina'
FEMALE_PERSON_ONE_RU = {
    'login': FEMALE_PERSON_ONE_LOGIN,
    'first_name': 'Елена',
    'last_name': 'Бунина',
    'gender': 'f',
}
FEMALE_PERSON_ONE_EN = {
    'login': FEMALE_PERSON_ONE_LOGIN,
    'first_name': 'Elena',
    'last_name': 'Bunina',
    'gender': 'f',
}
FEMALE_PERSON_TWO_LOGIN = 'natasha'
FEMALE_PERSON_TWO_RU = {
    'login': FEMALE_PERSON_TWO_LOGIN,
    'first_name': 'Наталия',
    'last_name': 'Осташева',
    'gender': 'f',
}
FEMALE_PERSON_TWO_EN = {
    'login': FEMALE_PERSON_TWO_LOGIN,
    'first_name': 'Natalia',
    'last_name': 'Ostasheva',
    'gender': 'f',
}
REVIEW_ONE = {
    'id': 10,
    'name': 'Ревью Поискового портала'
}
REVIEW_ONE_EN = {
    'id': 11,
    'name': 'Search Portal Review'
}
REVIEW_TWO = {
    'id': 15,
    'name': 'Ревью HR-департамента'
}
COMMENT_SHORT_ONE = "Хорошо поработал"
COMMENT_WIKI = """
<div
    class="wiki-doc wiki-doc_magiclinks_yes i-bem"
    data-bem=\'{"wiki-doc":{
        "user":{"codeTheme":"github"},
        "wiki-attrs":{
            "lang":"ru",
            "pos_end":9,
            "code_theme":"github",
            "magiclinks_url":"https://wf.yandex-team.ru/magiclinks/v1/links",
            "mode":"view",
            "env":"production",
            "pos_start":0
        }
    }}\'
>
    <div class="wiki-p"><strong class="wiki-bold">
        Ну так
    </strong></div>
</div>\n<!--wf-ws v5.1-9-->
"""
COMMENT_LONG_ONE = """
Идейные соображения высшего порядка, а также дальнейшее развитие различных форм деятельности позволяет выполнять важные задания по разработке существенных финансовых и административных условий.
Повседневная практика показывает, что новая модель организационной деятельности требуют определения и уточнения модели развития.
"""
CALIBRATION = {
    'id': 1,
    'name': 'calibration',
    'start_date': '2018-01-01',
    'finish_date': '2018-01-02',
}


DEV_CONTEXT = {
    'calibrator_added_en': {
        'calibration': CALIBRATION,
        'admins': [FEMALE_PERSON_ONE_EN, MALE_PERSON_ONE_EN],
    },
    'calibrator_added_ru': {
        'calibration': CALIBRATION,
        'admins': [FEMALE_PERSON_ONE_RU, MALE_PERSON_ONE_RU],
    },
    'person_review_announce_ru': {
        'review': REVIEW_ONE,
        'person_review': {
            'id': 100500,
            'review': REVIEW_ONE,
            'person': MALE_PERSON_ONE_RU,
        },
    },
    'person_review_announce_en': {
        'review': REVIEW_ONE_EN,
        'person_review': {
            'id': 100500,
            'review': REVIEW_ONE_EN,
            'person': MALE_PERSON_ONE_EN,
        },
    },
    'person_review_flag_ru': {
        'review': REVIEW_ONE,
        'change_data': [
            {
                'change_author': MALE_PERSON_ONE_RU,
                'changes': {
                    'flagged': [
                        {
                            'person_review': {
                                'review': REVIEW_ONE,
                                'person': MALE_PERSON_TWO_RU,
                            },
                        },
                        {
                            'person_review': {
                                'review': REVIEW_ONE,
                                'person': MALE_PERSON_THREE_RU,
                            },
                        },
                    ],
                    'unflagged': [
                        {
                            'person_review': {
                                'review': REVIEW_ONE,
                                'person': MALE_PERSON_TWO_RU,
                            },
                        },
                    ],
                },
            },
            {
                'change_author': FEMALE_PERSON_ONE_RU,
                'changes': {
                    'flagged': [
                        {
                            'person_review': {
                                'review': REVIEW_ONE,
                                'person': FEMALE_PERSON_TWO_RU,
                            },
                        },
                    ],
                    'unflagged': [],
                },
            },
        ],
    },
    'person_review_flag_en': {
        'review': REVIEW_ONE_EN,
        'change_data': [
            {
                'change_author': MALE_PERSON_ONE_EN,
                'changes': {
                    'flagged': [
                        {
                            'person_review': {
                                'review': REVIEW_ONE_EN,
                                'person': MALE_PERSON_TWO_EN,
                            },
                        },
                        {
                            'person_review': {
                                'review': REVIEW_ONE_EN,
                                'person': MALE_PERSON_THREE_EN,
                            },
                        },
                    ],
                    'unflagged': [
                        {
                            'person_review': {
                                'review': REVIEW_ONE_EN,
                                'person': MALE_PERSON_TWO_EN,
                            },
                        },
                    ],
                },
            },
            {
                'change_author': FEMALE_PERSON_ONE_EN,
                'changes': {
                    'flagged': [
                        {
                            'person_review': {
                                'review': REVIEW_ONE_EN,
                                'person': FEMALE_PERSON_TWO_EN,
                            },
                        },
                    ],
                    'unflagged': [],
                },
            },
        ],
    },
    'person_review_approve_ru': {
        'review': REVIEW_ONE,
        'change_data': [
            {
                'change_author': MALE_PERSON_ONE_RU,
                'changes': [
                    {
                        'person_review': {
                            'review': REVIEW_ONE,
                            'person': MALE_PERSON_TWO_RU,
                        },
                    },
                    {
                        'person_review': {
                            'review': REVIEW_ONE,
                            'person': MALE_PERSON_THREE_RU,
                        },
                    },
                ],
            },
            {
                'change_author': FEMALE_PERSON_ONE_RU,
                'changes': [
                    {
                        'person_review': {
                            'review': REVIEW_ONE,
                            'person': FEMALE_PERSON_TWO_RU,
                        },
                    },
                ],
            },
        ],
    },
    'person_review_approve_en': {
        'review': REVIEW_ONE_EN,
        'change_data': [
            {
                'change_author': MALE_PERSON_ONE_EN,
                'changes': [
                    {
                        'person_review': {
                            'review': REVIEW_ONE_EN,
                            'person': MALE_PERSON_TWO_EN,
                        },
                    },
                    {
                        'person_review': {
                            'review': REVIEW_ONE_EN,
                            'person': MALE_PERSON_THREE_EN,
                        },
                    },
                ],
            },
            {
                'change_author': FEMALE_PERSON_ONE_EN,
                'changes': [
                    {
                        'person_review': {
                            'review': REVIEW_ONE_EN,
                            'person': FEMALE_PERSON_TWO_EN,
                        },
                    },
                ],
            },
        ],
    },
    'person_review_unapprove_ru': {
        'review': REVIEW_ONE,
        'change_data': [
            {
                'change_author': MALE_PERSON_ONE_RU,
                'changes': [
                    {
                        'person_review': {
                            'review': REVIEW_ONE,
                            'person': MALE_PERSON_TWO_RU,
                        },
                    },
                    {
                        'person_review': {
                            'review': REVIEW_ONE,
                            'person': MALE_PERSON_THREE_RU,
                        },
                    },
                ],
            },
            {
                'change_author': FEMALE_PERSON_ONE_RU,
                'changes': [
                    {
                        'person_review': {
                            'review': REVIEW_ONE,
                            'person': FEMALE_PERSON_TWO_RU,
                        },
                    },
                ],
            },
        ],
    },
    'person_review_unapprove_en': {
        'review': REVIEW_ONE_EN,
        'change_data': [
            {
                'change_author': MALE_PERSON_ONE_EN,
                'changes': [
                    {
                        'person_review': {
                            'review': REVIEW_ONE_EN,
                            'person': MALE_PERSON_TWO_EN,
                        },
                    },
                    {
                        'person_review': {
                            'review': REVIEW_ONE_EN,
                            'person': MALE_PERSON_THREE_EN,
                        },
                    },
                ]
            },
            {
                'change_author': FEMALE_PERSON_ONE_EN,
                'changes': [
                    {
                        'person_review': {
                            'review': REVIEW_ONE_EN,
                            'person': FEMALE_PERSON_TWO_EN,
                        },
                    },
                ],
            },
        ]
    },
    'person_review_comment_ru': {
        'review': REVIEW_ONE,
        'comment_data': [
            {
                'person_review': {
                    'id': 100500,
                    'person': MALE_PERSON_TWO_RU,
                    'review': REVIEW_ONE,
                },
                'comments': [
                    {
                        'updated_at': '2018-01-01T10:44:00',
                        'subject': MALE_PERSON_ONE_RU,
                        'text_wiki': COMMENT_LONG_ONE,
                    },
                ],
            },
            {
                'person_review': {
                    'id': 100501,
                    'person': FEMALE_PERSON_ONE_RU,
                    'review': REVIEW_ONE,
                },
                'comments': [
                    {
                        'updated_at': '2018-01-01T10:44:00',
                        'subject': FEMALE_PERSON_TWO_RU,
                        'text_wiki': COMMENT_SHORT_ONE,
                    },
                    {
                        'updated_at': '2018-01-01T10:44:00',
                        'subject': MALE_PERSON_ONE_RU,
                        'text_wiki': COMMENT_WIKI,
                    },
                ],
            }
        ],
    },
    'person_review_comment_en': {
        'review': REVIEW_ONE_EN,
        'comment_data': [
            {
                'person_review': {
                    'id': 100500,
                    'person': MALE_PERSON_TWO_EN,
                    'review': REVIEW_ONE_EN,
                },
                'comments': [
                    {
                        'updated_at': '2018-01-01T10:44:00',
                        'subject': MALE_PERSON_ONE_EN,
                        'text_wiki': COMMENT_LONG_ONE,
                    },
                ],
            },
            {
                'person_review': {
                    'id': 100501,
                    'person': FEMALE_PERSON_ONE_EN,
                    'review': REVIEW_ONE_EN,
                },
                'comments': [
                    {
                        'updated_at': '2018-01-01T10:44:00',
                        'subject': FEMALE_PERSON_TWO_EN,
                        'text_wiki': COMMENT_SHORT_ONE,
                    },
                    {
                        'updated_at': '2018-01-01T10:44:00',
                        'subject': MALE_PERSON_ONE_EN,
                        'text_wiki': COMMENT_WIKI,
                    },
                ],
            }
        ],
    },
    'review_dates_reminder_ru': {
        'review': std.updated(
            REVIEW_ONE,
            finish_submission_date='2018-01-01',
            finish_approval_date=None,
        ),
        'wait_evaluation_count': 1,
        'wait_approval_count': 2,
    },
    'review_dates_reminder_en': {
        'review': std.updated(
            REVIEW_ONE_EN,
            finish_submission_date='2018-01-01',
            finish_approval_date=None,
        ),
        'wait_evaluation_count': 1,
        'wait_approval_count': 2,
    },
    'personreview_update_digest_en': {
        'change_data': [
            {
                'mark_changed_by': MALE_PERSON_ONE_EN,
                'level_changed_by': MALE_PERSON_ONE_EN,
                'person': MALE_PERSON_TWO_EN,
                'person_review_id': 12345,
                'review_id': REVIEW_ONE_EN['id'],
                'review_name': REVIEW_ONE_EN['name'],
            },
        ],
        'settings': {
            'STAFF_URL': 'https://staff.test.yandex-team.ru',
            'FRONTEND_URL': 'https://review.test.tools.yandex-team.ru',
        },
    },
    'personreview_update_digest_ru': {
        'change_data': [
            {
                'mark_changed_by': MALE_PERSON_ONE_RU,
                'level_changed_by': MALE_PERSON_ONE_RU,
                'person': MALE_PERSON_TWO_RU,
                'person_review_id': 12345,
                'review_id': REVIEW_ONE['id'],
                'review_name': REVIEW_ONE['name'],
            },
        ],
        'settings': {
            'STAFF_URL': 'https://staff.test.yandex-team.ru',
            'FRONTEND_URL': 'https://review.test.tools.yandex-team.ru',
        },
    },
}
