# coding: utf-8

# fields in Finance model
# these are syncing from OEBS and stored as-is
# stored in Finance model, only one per Person
SALARY_HISTORY = 'salary_history'
GRADE_HISTORY = 'grade_history'
BONUS_HISTORY = 'bonus_history'
OPTION_HISTORY = 'options_history'
CURRENT_SALARY = 'current_salary'
CURRENT_LOANS = 'current_loans'
SOCIAL_PACKAGE = 'social_package'

# calculable based on previous fields
HAS_NOT_VESTED_OPTIONS = 'has_not_vested_options'
NOT_VESTED_OPTIONS = 'not_vested_options'

# is synced per PersonReview
KPI = 'kpi'

# used for calculate loan
LOAN_CALC = 'loan_calc'

OEBS_DATA_TYPES = frozenset([
    SALARY_HISTORY,
    GRADE_HISTORY,
    BONUS_HISTORY,
    OPTION_HISTORY,
    CURRENT_SALARY,
    CURRENT_LOANS,
    SOCIAL_PACKAGE,
])

FINANCE_DB_FIELDS = OEBS_DATA_TYPES

FINANCE_DB_FIELDS_IN_REVIEW = frozenset([
    'salary_history',
    'grade_history',
    'bonus_history',
    'options_history',
])

ROOT_COLLECTION_NAMES = {
    SALARY_HISTORY: 'salaries',
    GRADE_HISTORY: 'grades',
    BONUS_HISTORY: 'bonuses',
    OPTION_HISTORY: 'holders',
    CURRENT_SALARY: 'salaries',
    CURRENT_LOANS: 'logins',
    SOCIAL_PACKAGE: 'logins',
}

INNER_COLLECTION_NAMES = {
    SALARY_HISTORY: 'salaryHist',
    GRADE_HISTORY: 'gradeHist',
    BONUS_HISTORY: 'bonusesHist',
    OPTION_HISTORY: 'grants',
    CURRENT_LOANS: 'loans'
}
LIST_DATA_TYPES = frozenset(INNER_COLLECTION_NAMES)
NON_LIST_DATA_TYPES = OEBS_DATA_TYPES - LIST_DATA_TYPES


OEBS_DATA_FETCH_ERROR = 'OEBS_DATA_FETCH_ERROR'


class DEFAULT_CURRENCIES(object):
    RUB = 'RUB'
    USD = 'USD'
    UAH = 'UAH'
    EUR = 'EUR'
    CHF = 'CHF'
    CNY = 'CNY'
    ILS = 'ILS'
    ALL = frozenset([
        RUB,
        USD,
        UAH,
        EUR,
        CHF,
        CNY,
        ILS,
    ])


DEFAULT_PROFESSIONS_NAMES = {
    'Asessor': ('Асессор', 'Asessor'),
    'ContentManager': ('Контент-менеджер', 'Content manager'),
    'Support': ('Саппорт', 'Support'),
    'Operator': ('Оператор', 'Operator'),
    'Moderator': ('Модератор', 'Moderator'),
    'Mapmaker': ('Картограф', 'Mapmaker'),
    'TechWriter': ('Технический писатель', 'Tech writer'),
    'Editor': ('Редактор', 'Editor'),
    'Tester': ('Тестировщик', 'Tester'),
    'Analyst': ('Аналитик', 'Analyst'),
    'MarketingManager': ('Менеджер по маркетингу', 'Marketing manager'),
    'ClientManager': ('Менеджер по работе с клиентами', 'Client manager'),
    'PartnerManager': ('Менеджер по работе с партнерами', 'Partner manager'),
    'BisDevManager': ('Биздев', 'Biz dev manager'),
    'ProjectManager': ('Менеджер проектов', 'Project manager'),
    'Meteorologist': ('Метеоролог', 'Meteorologist'),
    'Translator': ('Переводчик', 'Translator'),
    'Designer': ('Дизайнер', 'Designer'),
    'AutoTester': ('Инженер по автоматизации тестирования', 'Auto tester'),
    'ProductManager': ('Менеджер продукта', 'Product manager'),
    'ReleaseEngineer': ('Релиз-инженер', 'Release engineer'),
    'SysAdmin': ('Системный администратор', 'System admininstrator'),
    'InterfaceDev': ('Разработчик интерфейсов', 'Interface developer'),
    'Developer': ('Разработчик', 'Developer'),
    'MobileDeveloper': ('Разработчик мобильных приложений', 'Mobile developer'),
    'Other': ('Другое', 'Other'),
    'TechManager': ('Технический менеджер', 'Tech manager'),
    'AnalystDeveloper': ('Разработчик-аналитик', 'Analyst developer'),
}
DEFAULT_PROFESSIONS = frozenset(DEFAULT_PROFESSIONS_NAMES)


MAX_HISTORY_DATE = '4712-12-31'

DATE_RANGED_EVENT_FIELDS = {
    SALARY_HISTORY,
    GRADE_HISTORY,
}

FINANCE_EVENT_TYPES = {
    SALARY_HISTORY: 's',
    GRADE_HISTORY: 'g',
}

FINANCE_EVENT_BY_TYPE = {
    type: name
    for name, type in FINANCE_EVENT_TYPES.items()
}

FINANCE_EVENT_CHOICES = list(FINANCE_EVENT_BY_TYPE.items())

DATE_EVENT_FIELDS = {
    BONUS_HISTORY: 'effectiveDate',
}
