from typing import List

import attr

from review.lib import attr_ext
from review.oebs.sync.fetch import OebsConnector
from review.oebs import const


@attr.s
class OebsLoan(object):
    """ Used both to get data from oebs and to return in our api"""
    @attr.s
    class Login(object):
        NDFL = attr.ib(converter=attr.converters.optional(int), default=0)
        avgIncome = attr.ib(converter=attr.converters.optional(float), default=0)
        salarySum = attr.ib(converter=attr.converters.optional(int), default=0)
        holdAmount = attr.ib(converter=attr.converters.optional(int), default=0)
        matProfitNDFL = attr.ib(converter=attr.converters.optional(int), default=0)
        login = attr.ib(converter=attr.converters.optional(str), default='')
        currency = attr.ib(converter=attr.converters.optional(str), default='RUB')
        basis = attr.ib(converter=attr.converters.optional(str), default='MONTHLY')
        headcount = attr.ib(converter=attr.converters.optional(str), default='Y')
        accountNotResident = attr.ib(converter=attr.converters.optional(str), default='N')
        expYears = attr.ib(converter=attr.converters.optional(int), default=0)
        expMonths = attr.ib(converter=attr.converters.optional(int), default=0)
        expDays = attr.ib(converter=attr.converters.optional(int), default=0)
        taxUnit = attr.ib(converter=attr.converters.optional(str), default='')
        homeFlag = attr.ib(converter=attr.converters.optional(str), default='N')
        maternityLeave = attr.ib(converter=attr.converters.optional(str), default='N')
        temporaryContract = attr.ib(converter=attr.converters.optional(str), default='N')
        loanFlag = attr.ib(converter=attr.converters.optional(str), default='N')
        execDoc = attr.ib(converter=attr.converters.optional(int), default=0)
        hiddenInfo = attr.ib(converter=attr.converters.optional(bool), default=False)

    logins = attr.ib(type=List[Login])
    refinanceRate = attr.ib(type=float, default=0)


def get_person_loan(login):
    # type: (str) -> OebsLoan
    data = OebsConnector().post(
        resource=const.LOAN_CALC,
        json={'login': [login]},
    )
    return OebsLoan(
        refinanceRate=data['refinanceRate'],
        logins=[
            attr_ext.from_kwargs(OebsLoan.Login, kw)
            for kw in data['logins']
        ]
    )
