# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2017-12-05 09:43

from django.db import (
    migrations,
    transaction,
)

from review.oebs import (
    admin,
    const,
    models,
)


@transaction.atomic
def migrate(apps, schema_editor):
    currencies = list(models.Currency.objects.all())
    if currencies:
        add_order_for_currencies(currencies)
    else:
        admin.reset_currencies_to_default()
    professions = list(models.Profession.objects.order_by('key'))
    if professions:
        add_order_for_professions(professions)
    else:
        admin.reset_professions_to_default()


def add_order_for_currencies(currencies):
    currencies = sorted(
        currencies,
        key=lambda m: (m.key != const.DEFAULT_CURRENCIES.RUB, m.key)
    )
    for i, currency in enumerate(currencies):
        currency.order = i
        currency.save()


def add_order_for_professions(professions):
    for i, profession in enumerate(professions):
        profession.order = i
        profession.save()


def backwards(apps, schema_editor):
    from review.oebs import models
    models.Currency.objects.all().update(order=0)
    models.Profession.objects.all().update(order=0)


class Migration(migrations.Migration):

    dependencies = [
        ('oebs', '0006_add_ordering_for_currency_and_profession'),
    ]

    operations = [
        migrations.RunPython(
            code=migrate,
            reverse_code=backwards,
        ),
    ]
