# coding: utf-8

from django.db import models

from review.oebs import const


class Finance(models.Model):

    person = models.OneToOneField(
        to='staff.Person',
        primary_key=True,
    )
    salary_history = models.TextField()
    grade_history = models.TextField()
    bonus_history = models.TextField()
    options_history = models.TextField()
    current_salary = models.TextField()
    current_loans = models.TextField()
    social_package = models.TextField()

    created_at_auto = models.DateTimeField(auto_now_add=True)
    updated_at_auto = models.DateTimeField(auto_now=True)


class FinanceEvents(models.Model):
    person = models.ForeignKey(
        to='staff.Person',
        related_name='finance_events',
        related_query_name='finance_event',
    )
    type = models.CharField(choices=const.FINANCE_EVENT_CHOICES, max_length=1)
    date_from = models.DateField()
    date_to = models.DateField()

    event = models.TextField()

    created_at_auto = models.DateTimeField(auto_now_add=True)
    updated_at_auto = models.DateTimeField(auto_now=True)

    class Meta:
        indexes = [models.Index(fields=['person', 'date_from', 'date_to', 'type'])]
        unique_together = ('person', 'date_from', 'date_to', 'type')


class FinanceMock(models.Model):

    person = models.OneToOneField(
        to='staff.Person',
        primary_key=True,
    )
    salary_history = models.TextField()
    grade_history = models.TextField()
    bonus_history = models.TextField()
    options_history = models.TextField()
    current_salary = models.TextField()
    current_loans = models.TextField()
    social_package = models.TextField()

    created_at_auto = models.DateTimeField(auto_now_add=True)
    updated_at_auto = models.DateTimeField(auto_now=True)


class Currency(models.Model):

    key = models.CharField(max_length=3, unique=True)
    order = models.SmallIntegerField(default=0)

    def __str__(self):
        return '<%s: %s>' % (self.__class__.__name__, self.key)

    class Meta:
        verbose_name_plural = "currencies"
        ordering = ['order', 'key', 'id']


class Profession(models.Model):

    key = models.CharField(max_length=50, unique=True)
    name_ru = models.CharField(max_length=100)
    name_en = models.CharField(max_length=100)
    order = models.SmallIntegerField(default=0)

    class Meta:
        ordering = ['order', 'key', 'id']

    def __str__(self):
        return '<%s: %s>' % (self.__class__.__name__, self.key)
