# coding: utf-8

from django import forms
from django.conf import settings
from django.views.decorators import csrf
from django.utils.decorators import method_decorator

from review.lib import views, errors
from review.oebs.sync.store import sync_finance_data
from review.staff.models import Person


class LoginsForm(forms.Form):
    person = forms.ModelMultipleChoiceField(
        queryset=Person.objects.all(),
        to_field_name='login',
        required=True,
    )


@method_decorator(csrf.csrf_exempt, name='dispatch')
class SyncOebsView(views.View):
    form_cls_get = LoginsForm

    def process_get(self, auth, data):
        if auth.user.login not in settings.LOGINS_WHO_CAN_SYNC_OEBS:
            raise errors.PermissionDenied(
                action='sync oebs',
                type='any reason',
            )
        return sync_finance_data(
            person_filter={'login__in': [it.login for it in data['person']]},
            sync_type='real',
        )
