# coding: utf-8

from typing import List, Dict

from django.utils.functional import SimpleLazyObject

ROOT_DEPARTMENT_PATHS = SimpleLazyObject(lambda: get_root_department_paths())


def get_root_department_paths():  # type: () -> Dict[str, str]
    from review.staff.models import Department
    return dict(
        Department.objects
        .filter(depth=1)
        .values_list('slug', 'path')
    )


class GENDER(object):
    MALE = 'm'
    FEMALE = 'f'

    VERBOSE = {
        MALE: 'male',
        FEMALE: 'female'
    }
    CHOICES = list(VERBOSE.items())
    ALL = frozenset(VERBOSE)


class STAFF_ROLE(object):

    class DEPARTMENT(object):
        HEAD = 'h'
        DEPUTY = 'd'
        VERBOSE = {
            HEAD: 'head',
            DEPUTY: 'deputy',
        }
        CHOICES = list(VERBOSE.items())
        ALL = frozenset(VERBOSE)

    class HR(object):
        HR_PARTNER = 'hp'
        HR_ANALYST = 'ha'
        FINANCE_VIEWER = 'fv'
        VERBOSE = {
            HR_PARTNER: 'hr_partner',
            HR_ANALYST: 'hr_analyst',
            FINANCE_VIEWER: 'finance_viewer',
        }
        CHOICES = list(VERBOSE.items())
        ALL = frozenset(VERBOSE)

    ALL = frozenset(DEPARTMENT.ALL | HR.ALL)
    CHOICES = DEPARTMENT.CHOICES + HR.CHOICES
    VERBOSE = dict(CHOICES)


class SUBORDINATION(object):

    INDIRECT = 'i'
    DIRECT = 'd'
    ANY = 'a'
    ANY_CHOICES = (INDIRECT, DIRECT)

    VERBOSE = {
        INDIRECT: 'indirect',
        DIRECT: 'direct',
        ANY: 'any',
    }

    VERBOSE_REVERSED = {value: key for key, value in VERBOSE.items()}
    ALL = frozenset(VERBOSE)
    CHOICES = []

    for (key, value) in VERBOSE.items():
        if key in (INDIRECT, DIRECT):
            CHOICES.append((key, value))

    FILTER_CHOICES = (
        (VERBOSE[DIRECT], VERBOSE[DIRECT]),
        (VERBOSE[ANY], VERBOSE[ANY]),
    )


PERSON_WITH_HEADS = 'person_with_heads'
UMBRELLAS = 'umbrellas'
UMBRELLAS_ENGAGEMENT = 'umbrella_engagement'
VS_ENGAGEMENT = 'vs_engagement'

LOCALIZED_PERSON_FIELDS = (
    'first_name',
    'last_name',
    'position',
    'department__name',
    'city_name',
)
